;; makeinfo.el -- make info files from texinfo files

;; Copyright (C) 1985, 1986, 1988, 1990, 1991, 1992, 1993, 
;;               1994, 1995, 1996, 1997 Free Software Foundation, Inc.
;; Copyright (C) 1999 Yoshiki Hayashi <t90553@mail.ecc.u-tokyo.ac.jp>

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(or (featurep 'mule)
    (error "Emacs without mule is not supported"))
(require 'texinfmt)

(if (featurep 'xemacs)
    (set-language-environment "Japanese")
  ;; GNU Emacs
  (if (>= emacs-major-version 20)
      (progn (set-language-environment "Japanese")
	     (and (= emacs-major-version 20)
		  (> emacs-minor-version 2);; Emacs 20.2 dumps core
		  (set-terminal-coding-system 'euc-japan)))))

(find-file (car command-line-args-left))

(if (featurep 'xemacs)
    (setq coding-system-for-write buffer-file-coding-system)
;; GNU Emacs
(if (>= emacs-major-version 20)
    (setq coding-system-for-write buffer-file-coding-system)
)

;; Without this, MULE 2.3 saves file with iso-2022-jp
(if (= emacs-major-version 19)
    (setq-default file-coding-system file-coding-system)
))
;; texinfmt.el workaround
;; all version
(defun texinfo-format-var () ;; avoid texinfm bug.
  (let ((arg (texinfo-parse-expanded-arg)))
    (texinfo-discard-command)
    (insert (upcase arg))))

(defun texinfo-format-xref ()
  (let ((args (texinfo-format-parse-args)))
    (texinfo-discard-command)
    (insert "*Note ")
    (let ((fname (or (nth 1 args) (nth 2 args))))
      (if (null (or fname (nth 3 args)))
          (insert (car args) "::")
        (insert (or fname (car args)) ": ")
        (if (nth 3 args)
            (insert "(" (nth 3 args) ")"))
        (and (car args) (insert (car args)))))))

(and (string< texinfmt-version "2.38 of 3 July 1998")
;; Emacs 20.2
(put 'uref 'texinfo-format 'texinfo-format-uref)
(defun texinfo-format-uref ()
  "Format URL and optional URL-TITLE.
Insert ` ... ' around URL if no URL-TITLE argument;
otherwise, insert URL-TITLE followed by URL in parentheses."
  (let ((args (texinfo-format-parse-args)))
    (texinfo-discard-command)
    ;; if url-title
    (if (nth 1 args)
        (insert  (nth 1 args) " (" (nth 0 args) ")")
      (insert "`" (nth 0 args) "'"))
    (goto-char texinfo-command-start)))
)
(and (string< texinfmt-version "2.37 of 24 May 1997")
;; MULE 2.3
(put 'direntry 'texinfo-format 'texinfo-format-direntry)
(defun texinfo-format-direntry ()
  (texinfo-push-stack 'direntry nil)
  (texinfo-discard-line)
  (insert "START-INFO-DIR-ENTRY\n\n"))

(put 'direntry 'texinfo-end 'texinfo-end-direntry)
(defun texinfo-end-direntry ()
  (texinfo-discard-command)
  (insert "END-INFO-DIR-ENTRY\n\n")
  (texinfo-pop-stack 'direntry))

(put 'dircategory 'texinfo-format 'texinfo-format-dircategory)
(defun texinfo-format-dircategory ()
  (let ((str (texinfo-parse-arg-discard)))
    (delete-region (point)
                   (progn
                     (skip-chars-forward " ")
                     (point)))
    (insert "INFO-DIR-SECTION " str "\n")))
(put 'email 'texinfo-format 'texinfo-format-key)
(defun texinfo-format-key ()
  (insert (texinfo-parse-arg-discard))
  (goto-char texinfo-command-start))
(put 'url 'texinfo-format 'texinfo-format-code)
(put 'detailmenu 'texinfo-format 'texinfo-discard-line)
(put 'detailmenu 'texinfo-end 'texinfo-discard-command)
(put 'ringaccent 'texinfo-format 'texinfo-format-ring-accent)
(defun texinfo-format-ring-accent ()
   (insert "*" (texinfo-parse-arg-discard))
   (goto-char texinfo-command-start))
)
;; workaround ends

(texinfo-every-node-update)
(texinfo-format-buffer)
(save-buffer)
(kill-emacs)
