;; tagify.el -- make info files for info-stnd to for XEmacs

;; Copyright (C) 2002 Free Software Foundation, Inc.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; This Emacs lisp is almost from makeinfo.el.

(or (featurep 'mule)
    (error "Emacs without mule is not supported"))
(require 'texinfmt)

(if (featurep 'xemacs)
    (set-language-environment "Japanese")
  ;; GNU Emacs
  (if (>= emacs-major-version 20)
      (progn (set-language-environment "Japanese")
	     (and (= emacs-major-version 20)
		  (> emacs-minor-version 2);; Emacs 20.2 dumps core
		  (set-terminal-coding-system 'euc-japan)))))

(find-file (car command-line-args-left))

(if (featurep 'xemacs)
    (setq coding-system-for-write buffer-file-coding-system)
;; GNU Emacs
(if (>= emacs-major-version 20)
    (setq coding-system-for-write buffer-file-coding-system)
)

;; Without this, MULE 2.3 saves file with iso-2022-jp
(if (= emacs-major-version 19)
    (setq-default file-coding-system file-coding-system)
))

(Info-tagify)
(save-buffer)
(kill-emacs)
